#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmModifyUnits;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_ModifiedUnit : BaseTest 
	{

		private BOL.ModifiedUnit _modifiedUnit;
		private DataRow _drModifiedUnit;
		private DateTime _modificationDateTime;
		private System.Guid _supplyGuid;
		private BOL.BloodUnitModification _splitBUM;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			//Because of the timezone stuff, we set current datetime to use db
			this._modificationDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if (this.RefreshData)
			{
				this._supplyGuid = DataCreator.GetRecordGuid("SELECT TOP 1 SupplyGuid FROM Supply");

				this.RefreshData = false;
			}

			BOL.BloodUnit splitThisUnit = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, true);
			this._splitBUM = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime , Common.LogonUser.LogonUserName);
			this._splitBUM.SplitUnit(splitThisUnit.BloodUnitGuid, 2);
			this._splitBUM.Save(Common.UpdateFunction.UnitTests);

			//Might need to do a pool, and modifyunit to better sample
			this._modifiedUnit = new BOL.ModifiedUnit(splitThisUnit.BloodUnitGuid, this._splitBUM);
			DataTable dt = DAL.BloodUnitModification.GetEmptyBloodUnitModificationTable(false);
			this._drModifiedUnit = this._modifiedUnit.LoadDataRowFromThis(dt.NewRow());

			this._modifiedUnit.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.ModifyModifiedUnitClosed);
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.BloodUnit testBloodUnit = new BOL.BloodUnit((System.Guid)this._drModifiedUnit[TABLES.BloodUnitModification.FromBloodUnitGuid]);

			Assert.IsTrue(testBloodUnit.BloodUnitGuid == this._modifiedUnit.FromBloodUnitGuid);
			Assert.IsTrue(testBloodUnit.BloodUnitStatus.UnitStatusCode == this._modifiedUnit.NewUnit.BloodUnitStatus.UnitStatusCode);
		}

		[Test]
		public void Ctor_Guid_Fail()
		{
			System.Guid unitGuid = this._splitBUM.SplittingUnit.BloodUnitGuid;

			//Check for BloodUnitGuid fail
			try
			{
				BOL.ModifiedUnit testUnit = new BOL.ModifiedUnit(System.Guid.Empty, this._splitBUM);
				Assert.AreEqual(false, true, "EmptyGuid parm");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "EmptyGuid parm");
			}

			//Check for ProductModificationCode fail
			try
			{
				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Unknown, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
				BOL.ModifiedUnit testUnit = new BOL.ModifiedUnit(unitGuid, tstBUM);
				Assert.AreEqual(false, true, "ProductModificationCode parm");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ProductModificationCode parm");
			}

			//Check for ModifyUnitMethod fail
			try
			{
				BOL.BloodUnitModification tstBum = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.None, this._modificationDateTime, Common.LogonUser.LogonUserName);
				BOL.ModifiedUnit testUnit = new BOL.ModifiedUnit(unitGuid, tstBum);
				Assert.AreEqual(false, true, "ModifyUnitMethod parm");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "ModifyUnitMethod parm");
			}
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.ModifiedUnit testModifiedUnit = new BOL.ModifiedUnit(this._drModifiedUnit);

			Assert.IsTrue(testModifiedUnit.FromBloodUnitGuid == this._modifiedUnit.FromBloodUnitGuid);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{
			DataTable dtTest = new DataTable("UnitTest");
			dtTest.Columns.Add(TABLES.BloodUnit.BloodUnitGuid,typeof(System.Guid));

			DataRow dtRow = dtTest.NewRow();
			
			BOL.ModifiedUnit testUnit = new BOL.ModifiedUnit(dtRow);
		}

		[Test]
		public void BloodUnitModificationGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();

			this._modifiedUnit.BloodUnitModificationGuid = tmpValue;

			Assert.AreEqual(tmpValue, this._modifiedUnit.BloodUnitModificationGuid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void BloodUnitModificationGuid_Fail()
		{
		}

		[Test]
		public void ProductModificationCode_Pass()
		{
			Assert.IsTrue(this._modifiedUnit.ProductModificationCode == Common.ProductModification.SplitAdult);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ProductModificationCode_Fail()
		{
		}

		[Test]
		public void ModificationMethod_Pass()
		{
			Assert.IsTrue(this._modifiedUnit.ModificationMethod == Common.ModifyUnitMethod.Closed);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ModificationMethod_Fail()
		{
		}

		[Test]
		public void ModificationDateTime_Pass()
		{
			Assert.IsTrue(this._modifiedUnit.ModificationDateTime == _modificationDateTime);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ModificationDateTime_Fail()
		{
		}

		[Test]
		public void NewUnit_Pass()
		{
			Assert.IsTrue(this._modifiedUnit.NewUnit.BloodUnitGuid != (System.Guid)this._drModifiedUnit[TABLES.BloodUnitModification.FromBloodUnitGuid]);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void NewUnit_Fail()
		{
		}

		[Test]
		public void FromBloodUnitGuid_Pass()
		{
			System.Guid tmpValue = (System.Guid)this._drModifiedUnit[TABLES.BloodUnitModification.FromBloodUnitGuid];

			Assert.IsTrue(this._modifiedUnit.FromBloodUnitGuid == tmpValue);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void FromBloodUnitGuid_Fail()
		{
		}

		[Test]
		public void ToBloodUnitGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();
			
			this._modifiedUnit.ToBloodUnitGuid = tmpValue;

			Assert.AreEqual(tmpValue, this._modifiedUnit.ToBloodUnitGuid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ToBloodUnitGuid_Fail()
		{
		}

		[Test]
		public void TargetBloodProduct_Pass()
		{
			BOL.BloodProduct tmpValue = new BOL.BloodProduct(this._modifiedUnit.NewUnit.BloodProductGuid);

			Assert.IsTrue(this._modifiedUnit.TargetBloodProduct.ProductName == tmpValue.ProductName);
		}

		[Test]
		public void TargetBloodProduct_Fail()
		{
			this._modifiedUnit.TargetBloodProduct = this._modifiedUnit.TargetBloodProduct;
			int beforeCount = this._modifiedUnit.BrokenRulesCount;
			//
			this._modifiedUnit.TargetBloodProduct = null;
			Assert.AreEqual(beforeCount+1,this._modifiedUnit.BrokenRulesCount,"BloodProductBrokenRule");
		}


		[Test]
		public void NewLabelVerificationDateTime_Pass()
		{
			DateTime tmpValue = DateTime.Now;

			this._modifiedUnit.NewLabelVerificationDateTime = tmpValue;

			Assert.IsTrue(this._modifiedUnit.NewLabelVerificationDateTime == tmpValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void NewLabelVerificationDateTime_Fail()
		{
			this._modifiedUnit.NewLabelVerificationDateTime = DateTime.MinValue;
		}

		[Test]
		public void WeldIndicator_Pass()
		{
			bool tmpValue = !(this._modifiedUnit.WeldIndicator);

			this._modifiedUnit.WeldIndicator = tmpValue;

			Assert.IsTrue(this._modifiedUnit.WeldIndicator == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void WeldIndicator_Fail()
		{
		}

		[Test]
		public void UnitContainerLotNumber_Pass()
		{
			//This is the Closed Split Test
			string originalLotNumber = this._modifiedUnit.UnitContainerLotNumber;
			BOL.Supply tmpSupply = new BOL.Supply(this._supplyGuid);
			this._modifiedUnit.Container = tmpSupply;
			Assert.IsTrue(this._modifiedUnit.UnitContainerLotNumber == originalLotNumber);

			BOL.BloodUnitModification tmpBUM = new BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			BOL.BloodUnit tmpClosedThaw = DataCreator.CreateModifiableBloodUnit(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, true);
            tmpBUM.ModifyUnit(tmpClosedThaw.BloodUnitGuid);
			tmpBUM.Save(Common.UpdateFunction.UnitTests);

			tmpBUM.ModifiedUnit.Container = tmpSupply;
			Assert.IsTrue(tmpBUM.ModifiedUnit.UnitContainerLotNumber == tmpSupply.LotNumber);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitContainerLotNumber_Fail()
		{
		}

		[Test]
		public void UnitExpirationDate_Pass()
		{
			DateTime tmpValue = DateTime.Now.AddYears(1);

			this._modifiedUnit.UnitExpirationDate = tmpValue;

			Assert.IsTrue(this._modifiedUnit.UnitExpirationDate == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnitExpirationDate_Fail()
		{
		}

		[Test]
		public void EquipmentList_Pass()
		{
			string setValue = "test";
			System.Collections.ArrayList tmpValue = new System.Collections.ArrayList();

			tmpValue.Add(setValue);

			this._modifiedUnit.EquipmentList = tmpValue;

			Assert.IsTrue(this._modifiedUnit.EquipmentList[0].ToString() == setValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void EquipmentList_Fail()
		{
		}

		[Test]
		public void SupplyList_Pass()
		{
			string setValue = "test";
			System.Collections.ArrayList tmpValue = new System.Collections.ArrayList();

			tmpValue.Add(setValue);

			this._modifiedUnit.SupplyList = tmpValue;

			Assert.IsTrue(this._modifiedUnit.SupplyList[0].ToString() == setValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SupplyList_Fail()
		{
		}

		[Test]
		public void Container_Pass()
		{
			BOL.Supply tmpValue = new BOL.Supply(this._supplyGuid);

			this._modifiedUnit.Container = tmpValue;

			Assert.IsTrue(this._modifiedUnit.Container.SupplyGuid == this._supplyGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Container_Fail()
		{
		}

		[Test]
		public void SCDWafer_Pass()
		{
			BOL.Supply tmpValue = new BOL.Supply(this._supplyGuid);

			this._modifiedUnit.SCDWafer = tmpValue;

			Assert.IsTrue(this._modifiedUnit.SCDWafer.SupplyGuid == this._supplyGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SCDWafer_Fail()
		{
		}

		[Test]
		public void GetBrokenRulesMessage_Pass()
		{
			this._modifiedUnit.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, Common.VbecsBrokenRules.FrmModifyUnits.RuleSets.ModifyModifiedUnitOpen);

			string tstValue = this._modifiedUnit.GetBrokenRulesMessage(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName);

			Assert.IsNotNull(tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBrokenRulesMessage_Fail()
		{
		}

		[Test]
		public void SetInitialBrokenRules_Pass()
		{
			this._modifiedUnit.SetInitialBrokenRules(Common.VbecsBrokenRules.FrmModifyUnits.FormClassName, Common.VbecsBrokenRules.FrmModifyUnits.RuleSets.ModifyModifiedUnitOpen);

			int tstValue = this._modifiedUnit.BrokenRulesCount;

			Assert.IsTrue(tstValue > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SetInitialBrokenRules_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow tmpValue = this._modifiedUnit.LoadDataRowFromThis(this._drModifiedUnit.Table.NewRow());

			Assert.IsTrue((System.Guid)tmpValue[TABLES.BloodUnitModification.BloodUnitModificationGuid] == this._modifiedUnit.BloodUnitModificationGuid);
			Assert.IsTrue((System.Guid)tmpValue[TABLES.BloodUnitModification.FromBloodUnitGuid] == this._modifiedUnit.FromBloodUnitGuid);
			Assert.IsTrue((System.Guid)tmpValue[TABLES.BloodUnitModification.ToBloodUnitGuid] == this._modifiedUnit.ToBloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void LoadBloodUnitShipmentInformation_Pass()
		{
			System.Guid shipmentGuid = System.Guid.NewGuid();
			DataRow tmpValue = DAL.BloodUnitModification.GetEmptyBloodUnitShipmentTable().NewRow();

			tmpValue = this._modifiedUnit.LoadBloodUnitShipmentInformation(tmpValue, shipmentGuid);

			Assert.IsTrue((System.Guid)tmpValue[TABLES.BloodUnitShipment.IncomingShipmentGuid] == shipmentGuid);
			Assert.IsTrue((System.Guid)tmpValue[TABLES.BloodUnitShipment.BloodUnitGuid] == this._modifiedUnit.ToBloodUnitGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadBloodUnitShipmentInformation_Fail()
		{
		}

		[Test]
		public void LoadBloodUnitInformation_Pass()
		{
			DataTable dtUnits = BOL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed,false);
			System.Guid origGuid = (System.Guid)dtUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
			System.Guid targetBPGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BLOODPRODUCT WHERE ProductTypeCode = 'E011'");
			BOL.BloodProduct targetBP = new BloodProduct(targetBPGuid);

			BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.Thawed, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
			tstBUM.ModifyUnit(origGuid);
			tstBUM.ModifiedUnit.TargetBloodProduct = new BloodProduct(targetBPGuid);

			DataTable dtBU = DAL.BloodUnit.GetEmptyBloodUnitTableSchema(true);
			DataTable dtBUF = DAL.BloodUnitFinance.GetEmptyBloodUnitFinanceTableSchema(true);
			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			DataTable dtBUS = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			DataRow drBU = tstBUM.ModifiedUnit.LoadBloodUnitInformation(dtBU.NewRow());
			Assert.AreEqual(tstBUM.ModifiedUnit.ToBloodUnitGuid, (System.Guid)drBU[TABLES.BloodUnit.BloodUnitGuid], TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(targetBPGuid, (System.Guid)drBU[TABLES.BloodUnit.BloodProductGuid], TABLES.BloodUnit.BloodProductGuid);

			DataRow drBUF = tstBUM.ModifiedUnit.LoadBloodUnitInformation(dtBUF.NewRow());
			Assert.AreEqual(tstBUM.ModifiedUnit.NewUnit.BloodUnitFinance.BloodUnitFinanceGuid, (System.Guid)drBUF[TABLES.BloodUnitFinance.BloodUnitFinanceGuid], TABLES.BloodUnitFinance.BloodUnitFinanceGuid);

			DataRow drBUM = tstBUM.ModifiedUnit.LoadBloodUnitInformation(dtBUM.NewRow());
			Assert.AreEqual(tstBUM.ModifiedUnit.NewUnit.BloodUnitMedia.BloodUnitMediaGuid, (System.Guid)drBUM[TABLES.BloodUnitMedia.BloodUnitMediaGuid], TABLES.BloodUnitMedia.BloodUnitMediaGuid);

			DataRow drBUS = tstBUM.ModifiedUnit.LoadBloodUnitInformation(dtBUS.NewRow());
			Assert.AreEqual(tstBUM.ModifiedUnit.NewUnit.BloodUnitStatus.BloodUnitStatusGuid, (System.Guid)drBUS[TABLES.BloodUnitStatus.BloodUnitStatusGuid], TABLES.BloodUnitStatus.BloodUnitStatusGuid);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadBloodUnitInformation_Fail()
		{
		}

		[Test]
		public void LoadModificationSupplyInformation_Pass()
		{
			System.Collections.ArrayList tmpValue = new System.Collections.ArrayList();
			System.Collections.ArrayList bumGuids = new System.Collections.ArrayList();
			
			BOL.Supply tmpSupply = new BOL.Supply(this._supplyGuid);
			bumGuids.Add(System.Guid.NewGuid());
			
			tmpValue.Add(tmpSupply);
			this._modifiedUnit.SupplyList = tmpValue;
			this._modifiedUnit.SCDWafer = tmpSupply;
			this._modifiedUnit.Container = tmpSupply;

			DataTable dtTest = this._modifiedUnit.LoadModificationSupplyInformation(bumGuids,false);
			Assert.AreEqual(3, dtTest.Rows.Count, "F-Rows.Count");

			System.Guid unitGuid = (System.Guid)dtTest.Rows[0][TABLES.Supply.SupplyGuid];
			Assert.AreEqual(tmpSupply.SupplyGuid, unitGuid, "F-Supply1");
			Assert.AreEqual("A", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "F-RecordStatusCode1");
			
			unitGuid = (System.Guid)dtTest.Rows[1][TABLES.Supply.SupplyGuid];
			Assert.AreEqual(tmpSupply.SupplyGuid, unitGuid, "F-Supply2");
			Assert.AreEqual("A", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "F-RecordStatusCode2");

			unitGuid = (System.Guid)dtTest.Rows[2][TABLES.Supply.SupplyGuid];
			Assert.AreEqual(tmpSupply.SupplyGuid, unitGuid, "F-Supply3");
			Assert.AreEqual("A", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "F-RecordStatusCode3");


			//Check the update flag 
			dtTest = this._modifiedUnit.LoadModificationSupplyInformation(bumGuids,true);
			Assert.AreEqual(3, dtTest.Rows.Count, "T-Rows.Count");

			Assert.AreEqual("X", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "T-RecordStatusCode1");
			Assert.AreEqual("X", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "T-RecordStatusCode2");
			Assert.AreEqual("X", dtTest.Rows[0][TABLES.ModificationSupply.RecordStatusCode].ToString(), "T-RecordStatusCode3");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadModificationSupplyInformation_Fail()
		{
		}

		[Test]
		public void LoadModificationEquipmentInformation_Pass()
		{
			System.Collections.ArrayList tmpValue = new System.Collections.ArrayList();
			System.Collections.ArrayList bumGuids = new System.Collections.ArrayList();

			BOL.Equipment tmpEquip = new BOL.Equipment(this._supplyGuid);
			bumGuids.Add(System.Guid.NewGuid());

			tmpValue.Add(tmpEquip);
			this._modifiedUnit.EquipmentList = tmpValue;

			DataTable dtTest = this._modifiedUnit.LoadModificationEquipmentInformation(bumGuids,false);
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "F-Rows.Count");

			System.Guid unitGuid = (System.Guid)dtTest.Rows[0][TABLES.Equipment.EquipmentGuid];
			Assert.AreEqual(tmpEquip.EquipmentGuid, unitGuid, "F-Guid");
			Assert.AreEqual("A", dtTest.Rows[0][TABLES.ModificationEquipment.RecordStatusCode].ToString(), "F-Status");

			//Test the update flag
			dtTest = this._modifiedUnit.LoadModificationEquipmentInformation(bumGuids,true);
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "T-Rows.Count");
			Assert.AreEqual("X", dtTest.Rows[0][TABLES.ModificationEquipment.RecordStatusCode].ToString(), "T-Status");

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadModificationEquipmentInformation_Fail()
		{
		}

		[Test]
		public void RecommendedExpirationDateTime_Pass()
		{
			this.RefreshData = true;

			System.DateTime bigDate = System.DateTime.Now.AddYears(1);
			System.DateTime smallDate = System.DateTime.Now.AddYears(-1);
			System.Guid unitGuid = System.Guid.Empty;
			DataTable dtUnit;
				
			//Tests WeldIndicator IF/ELSE block
			dtUnit = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.Open,false);
			if (dtUnit.Rows.Count == 0)
			{
				Assert.IsTrue(false, "No Valid Units to test Weld Indicator code");
			}
			else
			{
				unitGuid = (System.Guid)dtUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				//SETUP ExpirationDate to make data validation simpler
				string sSQL = "UPDATE BloodUnitMedia SET UnitExpirationDate = '" + bigDate.ToUniversalTime() + "' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'";
				UnitTestUtil.RunSQL(sSQL);

				BOL.BloodUnitModification tstBUM = new BOL.BloodUnitModification(Common.ProductModification.VolumeReduced, Common.ModifyUnitMethod.SterileConnectingDevice, this._modificationDateTime, Common.LogonUser.LogonUserName);
				tstBUM.ModifyUnit(unitGuid);

				//Should Add 0 hours to ModificationDateTime (Closed method)
				tstBUM.NewContainerWeldIndicator = true;
				Assert.AreEqual(tstBUM.OriginalUnit.BloodUnitMedia.UnitExpirationDate, tstBUM.ModifiedUnit.RecommendedExpirationDateTime(tstBUM) , "WeldComplete");

				//Should Add 24 hours to ModificationDateTime (Open method)
				tstBUM.NewContainerWeldIndicator = false;
				Assert.AreEqual(this._modificationDateTime.AddHours(24), tstBUM.ModifiedUnit.RecommendedExpirationDateTime(tstBUM) , "WeldInComplete");
			}


			//Tests Large Hour IF/ELSE block, also tests Rejuv/Freeze IF/ELSE block
			dtUnit = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.Frozen, Common.ModifyUnitMethod.Open,false);
			if (dtUnit.Rows.Count == 0)
			{
				Assert.IsTrue(false, "No Valid Units to test Large Hours code");
			}
			else
			{
				unitGuid = (System.Guid)dtUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				//SETUP ExpirationDate to make data validation simpler
				string sSQL = "UPDATE BloodUnitMedia SET UnitExpirationDate = '" + bigDate.ToUniversalTime() + "' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'";
				UnitTestUtil.RunSQL(sSQL);

				BOL.BloodUnitModification tstBUMFroze = new BOL.BloodUnitModification(Common.ProductModification.Frozen, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
				tstBUMFroze.ModifyUnit(unitGuid);

				//Should Add 10 Years@23:59 to ModificationDateTime
				Assert.AreEqual(this._modificationDateTime.Date.AddDays(3650).AddHours(23).AddMinutes(59).AddSeconds(59), tstBUMFroze.ModifiedUnit.RecommendedExpirationDateTime(tstBUMFroze) , "LargeHours");
			}

			//Tests Split IF block
			dtUnit = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open,false);
			if (dtUnit.Rows.Count == 0)
			{
				Assert.IsTrue(false, "No Valid Units to test Split-Open code");
			}
			else
			{
				unitGuid = (System.Guid)dtUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				//SETUP ExpirationDate to make data validation simpler
				string sSQL = "UPDATE BloodUnitMedia SET UnitExpirationDate = '" + bigDate.ToUniversalTime() + "' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'";
				UnitTestUtil.RunSQL(sSQL);

				BOL.BloodUnitModification tstBUMSplitOpen = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
				tstBUMSplitOpen.SplitUnit(unitGuid, 2);

				//Should Add 24Hours to ModificationDateTime
				Assert.AreEqual(this._modificationDateTime.AddHours(24), ((BOL.ModifiedUnit)tstBUMSplitOpen.SplitUnits[0]).RecommendedExpirationDateTime(tstBUMSplitOpen) , "SplitOpen");
			}

			//Tests Split ELSE block
			dtUnit = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed,false);
			if (dtUnit.Rows.Count == 0)
			{
				Assert.IsTrue(false, "No Valid Units to test Split-Closed code");
			}
			else
			{
				unitGuid = (System.Guid)dtUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				//SETUP ExpirationDate to make data validation simpler
				string sSQL = "UPDATE BloodUnitMedia SET UnitExpirationDate = '" + bigDate.ToUniversalTime() + "' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'";
				UnitTestUtil.RunSQL(sSQL);

				BOL.BloodUnitModification tstBUMSplitClosed = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Closed, this._modificationDateTime, Common.LogonUser.LogonUserName);
				tstBUMSplitClosed.SplitUnit(unitGuid,2);

				//Date comparisions drill down to the TICK level!!  ARRGHH!!
				//Expiration date is same as original
				Assert.AreEqual(((BOL.ModifiedUnit)tstBUMSplitClosed.SplitUnits[0]).NewUnit.BloodUnitMedia.UnitExpirationDate, ((BOL.ModifiedUnit)tstBUMSplitClosed.SplitUnits[0]).RecommendedExpirationDateTime(tstBUMSplitClosed) , "SplitClosed");
			}

			//Tests Smaller OriginalExpiration Date IF block
			dtUnit = DAL.BloodUnitModification.GetModifiableBloodUnits(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open,false);
			if (dtUnit.Rows.Count == 0)
			{
				Assert.IsTrue(false, "No Valid Units to test Use-Original-Expiration-Date code");
			}
			else
			{
				unitGuid = (System.Guid)dtUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];
				//SETUP ExpirationDate to make data validation simpler
				string sSQL = "UPDATE BloodUnitMedia SET UnitExpirationDate = '" + smallDate.ToUniversalTime() + "' WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'";
				UnitTestUtil.RunSQL(sSQL);

				BOL.BloodUnitModification tstBUMSplitOrig = new BOL.BloodUnitModification(Common.ProductModification.SplitAdult, Common.ModifyUnitMethod.Open, this._modificationDateTime, Common.LogonUser.LogonUserName);
				tstBUMSplitOrig.SplitUnit(unitGuid, 2);

				//Date comparisions drill down to the TICK level!!  CRIPES!!!!
				//Should always pick the smaller of the dates (orig vs. calculated -- when not freeze/rejuv)
				Assert.AreEqual(((BOL.ModifiedUnit)tstBUMSplitOrig.SplitUnits[0]).NewUnit.BloodUnitMedia.UnitExpirationDate, ((BOL.ModifiedUnit)tstBUMSplitOrig.SplitUnits[0]).RecommendedExpirationDateTime(tstBUMSplitOrig), "OrigDate");
			}
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecommendedExpirationDateTime_Fail()
		{
		}

		[Test]
		public void OriginalContainerIndicator_Pass()
		{
			bool tmpValue = !(this._modifiedUnit.OriginalContainerIndicator);

			this._modifiedUnit.OriginalContainerIndicator = tmpValue;

			Assert.IsTrue(this._modifiedUnit.OriginalContainerIndicator == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OriginalContainerIndicator_Fail()
		{
		}

		[Test]
		public void LabelVerificationFailed_Pass()
		{
			bool tmpValue = !(this._modifiedUnit.LabelVerificationFailed);

			this._modifiedUnit.LabelVerificationFailed = tmpValue;

			Assert.IsTrue(this._modifiedUnit.LabelVerificationFailed == tmpValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabelVerificationFailed_Fail()
		{
		}

	}
}
#endif



